#
#VID ec09baa3-a9f5-11d9-a788-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52141);
 script_cve_id("CVE-2005-0966");
 script_bugtraq_id(13003);
 script_version ("$");
 name = "FreeBSD Ports: gaim, ja-gaim, ko-gaim, ru-gaim";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   gaim
   ja-gaim
   ko-gaim
   ru-gaim

CVE-2005-0966
The IRC protocol plugin in Gaim 1.2.0, and possibly earlier versions,
allows (1) remote attackers to inject arbitrary Gaim markup via
irc_msg_kick, irc_msg_mode, irc_msg_part, irc_msg_quit, (2) remote
attackers to inject arbitrary Pango markup and pop up empty dialog
boxes via irc_msg_invite, or (3) malicious IRC servers to cause a
denial of service (application crash) by injecting certain Pango
markup into irc_msg_badmode, irc_msg_banned, irc_msg_unknown,
irc_msg_nochan functions.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://gaim.sourceforge.net/security/?id=14
http://www.vuxml.org/freebsd/ec09baa3-a9f5-11d9-a788-0001020eed82.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: gaim, ja-gaim, ko-gaim, ru-gaim";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"gaim");
if(!isnull(bver) && revcomp(a:bver, b:"1.2.1")<0) {
    security_note(0, data:"Package gaim version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ja-gaim");
if(!isnull(bver) && revcomp(a:bver, b:"1.2.1")<0) {
    security_note(0, data:"Package ja-gaim version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ko-gaim");
if(!isnull(bver) && revcomp(a:bver, b:"1.2.1")<0) {
    security_note(0, data:"Package ko-gaim version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ru-gaim");
if(!isnull(bver) && revcomp(a:bver, b:"1.2.1")<0) {
    security_note(0, data:"Package ru-gaim version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
