#
#VID 3b4a6982-0b24-11da-bc08-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55043);
 script_cve_id("CVE-2005-1850", "CVE-2005-1851", "CVE-2005-1852", "CVE-2005-2369", "CVE-2005-2370", "CVE-2005-2448");
 script_bugtraq_id(14345);
 script_version ("$");
 name = "FreeBSD Ports: gaim, ja-gaim, ko-gaim, ru-gaim";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   gaim
   ja-gaim
   ko-gaim
   ru-gaim
   kdenetwork
   pl-ekg
   centericq
   pl-gnugadu

CVE-2005-1850
Certain contributed scripts for ekg Gadu Gadu client 1.5 and earlier
create temporary files insecurely, with unknown impact and attack
vectors, a different vulnerability than CVE-2005-1916.

CVE-2005-1851
A certain contributed script for ekg Gadu Gadu client 1.5 and earlier
allows attackers to execute shell commands via unknown attack vectors.

CVE-2005-1852
Multiple integer overflows in libgadu, as used in Kopete in KDE 3.2.3
to 3.4.1, ekg before 1.6rc3, and other packages, allows remote
attackers to cause a denial of service (crash) and possibly execute
arbitrary code via an incoming message.

CVE-2005-2369
Multiple integer signedness errors in libgadu, as used in ekg before
1.6rc2 and other packages, may allow remote attackers to cause a
denial of service or execute arbitrary code.

CVE-2005-2370
Multiple 'memory alignment errors' in libgadu, as used in ekg before
1.6rc2 and other packages, allows remote attackers to cause a denial
of service (bus error) on certain architectures such as SPARC via an
incoming message.

CVE-2005-2448
Multiple 'endianness errors' in libgadu in ekg before 1.6rc2 allow
remote attackers to cause a denial of service (invalid behaviour in
applications) on big-endian systems.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://gaim.sourceforge.net/security/?id=20
http://www.kde.org/info/security/advisory-20050721-1.txt
http://marc.theaimsgroup.com/?l=bugtraq&m=112198499417250
http://www.vuxml.org/freebsd/3b4a6982-0b24-11da-bc08-0001020eed82.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: gaim, ja-gaim, ko-gaim, ru-gaim";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"gaim");
if(!isnull(bver) && revcomp(a:bver, b:"1.5.0")<0) {
    security_note(0, data:"Package gaim version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ja-gaim");
if(!isnull(bver) && revcomp(a:bver, b:"1.5.0")<0) {
    security_note(0, data:"Package ja-gaim version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ko-gaim");
if(!isnull(bver) && revcomp(a:bver, b:"1.5.0")<0) {
    security_note(0, data:"Package ko-gaim version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ru-gaim");
if(!isnull(bver) && revcomp(a:bver, b:"1.5.0")<0) {
    security_note(0, data:"Package ru-gaim version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"kdenetwork");
if(!isnull(bver) && revcomp(a:bver, b:"3.2.2")>0 && revcomp(a:bver, b:"3.4.2")<0) {
    security_note(0, data:"Package kdenetwork version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"pl-ekg");
if(!isnull(bver) && revcomp(a:bver, b:"1.6r3,1")<0) {
    security_note(0, data:"Package pl-ekg version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"centericq");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package centericq version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"pl-gnugadu");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package pl-gnugadu version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
