#
#VID b62c80c2-b81a-11da-bec5-00123ffe8333
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56450);
 script_cve_id("CVE-2005-0469", "CVE-2005-2040", "CVE-2006-0582", "CVE-2006-0677");
 script_version ("$");
 name = "FreeBSD Ports: heimdal";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: heimdal

CVE-2005-0469
Buffer overflow in the slc_add_reply function in various BSD-based
Telnet clients, when handling LINEMODE suboptions, allows remote
attackers to execute arbitrary code via a reply with a large number of
Set Local Character (SLC) commands.

CVE-2005-2040
Multiple buffer overflows in the getterminaltype function in telnetd
for Heimdal before 0.6.5 may allow remote attackers to execute
arbitrary code, a different vulnerability than CVE-2005-0468 and
CVE-2005-0469.

CVE-2006-0582
Unspecified vulnerability in rshd in Heimdal 0.6.x before 0.6.6 and
0.7.x before 0.7.2, when storing forwarded credentials, allows
attackers to overwrite arbitrary files and change file ownership via
unknown vectors.

CVE-2006-0677
telnetd in Heimdal 0.6.x before 0.6.6 and 0.7.x before 0.7.2 allows
remote unauthenticated attackers to cause a denial of service (server
crash) via unknown vectors that trigger a null dereference.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.pdc.kth.se/heimdal/advisory/2005-04-20
http://www.pdc.kth.se/heimdal/advisory/2005-06-20
http://www.pdc.kth.se/heimdal/advisory/2006-02-06
http://www.vuxml.org/freebsd/b62c80c2-b81a-11da-bec5-00123ffe8333.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: heimdal";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"heimdal");
if(!isnull(bver) && revcomp(a:bver, b:"0.6.6")<0) {
    security_note(0, data:"Package heimdal version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
