#
#VID 6e8f54af-a07d-11de-a649-000c2955660f
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 6e8f54af-a07d-11de-a649-000c2955660f
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64895);
 script_cve_id("CVE-2009-2944");
 script_version ("$");
 script_name("FreeBSD Ports: ikiwiki");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: ikiwiki

CVE-2009-2944
Incomplete blacklist vulnerability in the teximg plugin in ikiwiki
before 3.1415926 and 2.x before 2.53.4 allows context-dependent
attackers to read arbitrary files via crafted TeX commands.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://ikiwiki.info/security/#index35h2
http://www.vuxml.org/freebsd/6e8f54af-a07d-11de-a649-000c2955660f.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: ikiwiki");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"ikiwiki");
if(!isnull(bver) && revcomp(a:bver, b:"3.1415926")<0) {
    security_note(0, data:"Package ikiwiki version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
