#
#VID f7a3b18c-624c-4703-9756-b6b27429e5b0
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52456);
 script_bugtraq_id(6490);
 script_cve_id("CVE-2003-0744");
 script_version ("$");
 name = "FreeBSD Ports: leafnode";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: leafnode

CVE-2003-0744:
The fetchnews client in leafnode allows remote attackers
to cause a denial of service (process hang and termination)
via certain malformed Usenet news articles that cause
fetchnews to hang while waiting for input.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://leafnode.sourceforge.net/leafnode-SA-2002-01
http://sourceforge.net/mailarchive/message.php?msg_id=2796226
http://article.gmane.org/gmane.network.leafnode.announce/8
http://www.vuxml.org/freebsd/f7a3b18c-624c-4703-9756-b6b27429e5b0.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: leafnode";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"leafnode");
if(!isnull(bver) && revcomp(a:bver, b:"1.9.20")>=0 && revcomp(a:bver, b:"1.9.30")<0) {
    security_note(0, data:"Package leafnode version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
