#
#VID 3a408f6f-9c52-11d8-9366-0020ed76ef5a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52428);
 script_cve_id("CVE-2004-0421");
 script_bugtraq_id(10244);
 script_version ("$");
 name = "FreeBSD Ports: linux-png";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   linux-png
   png

CVE-2004-0421
The Portable Network Graphics library (libpng) 1.0.15 and earlier
allows attackers to cause a denial of service (crash) via a malformed
PNG image file that triggers an error that causes an out-of-bounds
read when creating the error message.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://bugzilla.redhat.com/bugzilla/show_bug.cgi?id=120508
http://rhn.redhat.com/errata/RHSA-2004-181.html
http://secunia.com/advisories/11505
http://www.osvdb.org/5726
http://www.vuxml.org/freebsd/3a408f6f-9c52-11d8-9366-0020ed76ef5a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: linux-png";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"linux-png");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.14_3")<=0) {
    security_note(0, data:"Package linux-png version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"1.2")>=0 && revcomp(a:bver, b:"1.2.2")<=0) {
    security_note(0, data:"Package linux-png version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"png");
if(!isnull(bver) && revcomp(a:bver, b:"1.2.5_4")<0) {
    security_note(0, data:"Package png version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
