#
#VID 86ada694-8b30-11de-b9d0-000c6e274733
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 86ada694-8b30-11de-b9d0-000c6e274733
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64787);
 script_cve_id("CVE-2009-1255");
 script_version ("$");
 script_name("FreeBSD Ports: memcached");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: memcached

CVE-2009-1255
The process_stat function in (1) Memcached before 1.2.8 and (2)
MemcacheDB 1.2.0 discloses (a) the contents of /proc/self/maps in
response to a stats maps command and (b) memory-allocation statistics
in response to a stats malloc command, which allows remote attackers
to obtain sensitive information such as the locations of memory
regions, and defeat ASLR protection, by sending a command to the
daemon's TCP port.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/34915/
http://www.vuxml.org/freebsd/86ada694-8b30-11de-b9d0-000c6e274733.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: memcached");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"memcached");
if(!isnull(bver) && revcomp(a:bver, b:"1.2.8")<0) {
    security_note(0, data:"Package memcached version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
