#
#VID 86c05550-12c1-11dd-bab7-0016179b2dd5
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60884);
 script_cve_id("CVE-2008-1845");
 script_version ("$");
 name = "FreeBSD Ports: mksh";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: mksh

CVE-2008-1845
The Korn shell (aka mksh) before R33d on MirOS (aka MirBSD) does not
flush the tty's I/O when invoking mksh in a new terminal, which allows
local users to gain privileges by opening a virtual terminal and
entering command sequences, which might later be executed in
opportunistic circumstances by a different user who launches mksh and
specifies that terminal with the -T option.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/29803/
http://www.mirbsd.org/mksh.htm#clog
http://www.vuxml.org/freebsd/86c05550-12c1-11dd-bab7-0016179b2dd5.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: mksh";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"mksh");
if(!isnull(bver) && revcomp(a:bver, b:"R33d")<0) {
    security_note(0, data:"Package mksh version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
