#
#VID 33ab4a47-bfc1-11d8-b00e-000347a4fa7d
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52438);
 script_cve_id("CVE-2003-0279", "CVE-2003-0318", "CVE-2004-0266", "CVE-2004-0269");
 script_version ("$");
 name = "FreeBSD Ports: phpnuke";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: phpnuke

CVE-2003-0279
Multiple SQL injection vulnerabilities in the Web_Links module for
PHP-Nuke 5.x through 6.5 allows remote attackers to steal sensitive
information via numeric fields, as demonstrated using (1) the viewlink
function and cid parameter, or (2) index.php.

CVE-2003-0318
Cross-site scripting (XSS) vulnerability in the Statistics module for
PHP-Nuke 6.0 and earlier allows remote attackers to insert arbitrary
web script via the year parameter.

CVE-2004-0266
SQL injection vulnerability in the 'public message' capability
(public_message) for Php-Nuke 6.x to 7.1.0 allows remote attackers
obtain the administrator password via the c_mid parameter.

CVE-2004-0269
SQL injection vulnerability in PHP-Nuke 6.9 and earlier, and possibly
7.x, allows remote attackers to inject arbitrary SQL code and gain
sensitive information via (1) the category variable in the Search
module or (2) the admin variable in the Web_Links module.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.waraxe.us/index.php?modname=sa&id=27
http://secunia.com/advisories/11920
http://www.vuxml.org/freebsd/33ab4a47-bfc1-11d8-b00e-000347a4fa7d.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: phpnuke";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"phpnuke");
if(!isnull(bver) && revcomp(a:bver, b:"7.3")<0) {
    security_note(0, data:"Package phpnuke version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
