#
#VID bec38383-e6cb-11de-bdd4-000c2930e89b
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID bec38383-e6cb-11de-bdd4-000c2930e89b
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66520);
 script_version ("$Revision$");
 script_name("FreeBSD Ports: pligg");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: pligg

=====

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/37349/
http://www.pligg.com/blog/775/pligg-cms-1-0-3-release/
http://www.vuxml.org/freebsd/bec38383-e6cb-11de-bdd4-000c2930e89b.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: pligg");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"pligg");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.3b")<0) {
    security_note(0, data:"Package pligg version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
