#
#VID 27c331d5-64c7-11d8-80e3-0020ed76ef5a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52455);
 script_cve_id("CVE-2004-0097");
 script_version ("$");
 name = "FreeBSD Ports: pwlib";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   pwlib
   asterisk
   openh323

CVE-2004-0097
Multiple vulnerabilities in PWLib before 1.6.0 allow remote attackers
to cause a denial of service and possibly execute arbitrary code, as
demonstrated by the NISCC/OUSPG PROTOS test suite for the H.225
protocol.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.uniras.gov.uk/vuls/2004/006489/h323.htm
http://www.ee.oulu.fi/research/ouspg/protos/testing/c07/h2250v4/index.html
http://www.southeren.com/blog/archives/000055.html
http://www.vuxml.org/freebsd/27c331d5-64c7-11d8-80e3-0020ed76ef5a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: pwlib";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"pwlib");
if(!isnull(bver) && revcomp(a:bver, b:"1.5.0_5")<0) {
    security_note(0, data:"Package pwlib version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"asterisk");
if(!isnull(bver) && revcomp(a:bver, b:"0.7.2")<=0) {
    security_note(0, data:"Package asterisk version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"openh323");
if(!isnull(bver) && revcomp(a:bver, b:"1.12.0_4")<0) {
    security_note(0, data:"Package openh323 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
