#
#VID 9c2460a4-f6b1-11dd-94d9-0030843d3802
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 9c2460a4-f6b1-11dd-94d9-0030843d3802
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63360);
 script_cve_id("CVE-2009-0478");
 script_version ("$");
 name = "FreeBSD Ports: squid";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: squid

CVE-2009-0478
Squid 2.7 to 2.7.STABLE5, 3.0 to 3.0.STABLE12, and 3.1 to 3.1.0.4
allows remote attackers to cause a denial of service via an HTTP
request with an invalid version number, which triggers a reachable
assertion in (1) HttpMsg.c and (2) HttpStatusLine.c.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.squid-cache.org/Advisories/SQUID-2009_1.txt
http://secunia.com/advisories/33731/
http://www.vuxml.org/freebsd/9c2460a4-f6b1-11dd-94d9-0030843d3802.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: squid";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"squid");
if(!isnull(bver) && revcomp(a:bver, b:"2.7.1")>=0 && revcomp(a:bver, b:"2.7.6")<0) {
    security_note(0, data:"Package squid version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"3.0.1")>=0 && revcomp(a:bver, b:"3.0.13")<0) {
    security_note(0, data:"Package squid version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
