#
#VID 692ab645-bf5d-11de-849b-00151797c2d4
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 692ab645-bf5d-11de-849b-00151797c2d4
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66115);
 script_cve_id("CVE-2009-3700");
 script_version ("$Revision$");
 script_name("FreeBSD Ports: squidGuard");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: squidGuard

CVE-2009-3700
** RESERVED **
This candidate has been reserved by an organization or individual that
will use it when announcing a new security problem.  When the
candidate has been publicized, the details for this candidate will be
provided.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.squidguard.org/Downloads/Patches/1.4/Readme.Patch-20091015
http://www.squidguard.org/Downloads/Patches/1.4/Readme.Patch-20091019
http://www.vuxml.org/freebsd/692ab645-bf5d-11de-849b-00151797c2d4.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: squidGuard");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"squidGuard");
if(!isnull(bver) && revcomp(a:bver, b:"1.4_2")<0) {
    security_note(0, data:"Package squidGuard version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
