#
#VID 79630c0c-8dcc-45d0-9908-4087fe1d618c
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52996);
 script_cve_id("CVE-2004-1036", "CVE-2005-0075", "CVE-2005-0103", "CVE-2005-0104");
 script_version ("$");
 name = "FreeBSD Ports: squirrelmail, ja-squirrelmail";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   squirrelmail
   ja-squirrelmail

CVE-2004-1036
Cross-site scripting (XSS) vulnerability in the decoding of encoded
text in certain headers in mime.php for SquirrelMail 1.4.3a and
earlier, and 1.5.1-cvs before 23rd October 2004, allows remote
attackers to execute arbitrary web script or HTML.

CVE-2005-0075
prefs.php in SquirrelMail before 1.4.4, with register_globals enabled,
allows remote attackers to inject local code into the SquirrelMail
code via custom preference handlers.

CVE-2005-0103
PHP remote code injection vulnerability in webmail.php in SquirrelMail
before 1.4.4 allows remote attackers to execute arbitrary PHP code by
modifying a URL parameter to reference a URL on a remote web server
that contains the code.

CVE-2005-0104
Cross-site scripting (XSS) vulnerability in webmail.php in
SquirrelMail before 1.4.4 allows remote attackers to inject arbitrary
web script or HTML via certain integer variables.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.squirrelmail.org/security/issue/2005-01-14
http://www.squirrelmail.org/security/issue/2005-01-19
http://www.squirrelmail.org/security/issue/2005-01-20
http://marc.theaimsgroup.com/?l=bugtraq&m=110702772714662
http://www.vuxml.org/freebsd/79630c0c-8dcc-45d0-9908-4087fe1d618c.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: squirrelmail, ja-squirrelmail";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"squirrelmail");
if(!isnull(bver) && revcomp(a:bver, b:"1.4.4")<0) {
    security_note(0, data:"Package squirrelmail version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ja-squirrelmail");
if(!isnull(bver) && revcomp(a:bver, b:"1.4.4")<0) {
    security_note(0, data:"Package ja-squirrelmail version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
