#
#VID f8536143-9bc4-11d9-b8b3-000a95bc6fae
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52152);
 script_cve_id("CVE-2005-0667");
 script_version ("$");
 name = "FreeBSD Ports: sylpheed, sylpheed-claws, sylpheed-gtk2";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   sylpheed
   sylpheed-claws
   sylpheed-gtk2

CVE-2005-0667
Buffer overflow in Sylpheed before 1.0.3 and other versions before
1.9.5 allows remote attackers to execute arbitrary code via an e-mail
message with certain headers containing non-ASCII characters that are
not properly handled when the user replies to the message.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://sylpheed.good-day.net/index.cgi.en#changes
http://www.vuxml.org/freebsd/f8536143-9bc4-11d9-b8b3-000a95bc6fae.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: sylpheed, sylpheed-claws, sylpheed-gtk2";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"sylpheed");
if(!isnull(bver) && revcomp(a:bver, b:"0.8")>=0 && revcomp(a:bver, b:"1.0.3")<0) {
    security_note(0, data:"Package sylpheed version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"1.9")>=0 && revcomp(a:bver, b:"1.9.5")<0) {
    security_note(0, data:"Package sylpheed version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"sylpheed-claws");
if(!isnull(bver) && revcomp(a:bver, b:"0.8")>=0 && revcomp(a:bver, b:"1.0.3")<0) {
    security_note(0, data:"Package sylpheed-claws version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"1.9")>=0 && revcomp(a:bver, b:"1.9.5")<0) {
    security_note(0, data:"Package sylpheed-claws version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"sylpheed-gtk2");
if(!isnull(bver) && revcomp(a:bver, b:"0.8")>=0 && revcomp(a:bver, b:"1.0.3")<0) {
    security_note(0, data:"Package sylpheed-gtk2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"1.9")>=0 && revcomp(a:bver, b:"1.9.5")<0) {
    security_note(0, data:"Package sylpheed-gtk2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
