#
#VID 927743d4-5ca9-11d9-a9e7-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52256);
 script_cve_id("CVE-2004-1035");
 script_bugtraq_id(11630);
 script_version ("$");
 name = "FreeBSD Ports: up-imapproxy";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   up-imapproxy
   pop3proxy

CVE-2004-1035
Multiple integer signedness errors in (1) imapcommon.c, (2) main.c,
(3) request.c, and (4) select.c for up-imapproxy IMAP proxy 1.2.2
allow remote attackers to cause a denial of service (server crash) and
possibly leak sensitive information via certain literal values that
are not properly handled when using the IMAP_Line_Read function.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://marc.theaimsgroup.com/?l=bugtraq&m=109995749510773
http://www.vuxml.org/freebsd/927743d4-5ca9-11d9-a9e7-0001020eed82.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: up-imapproxy";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"up-imapproxy");
if(!isnull(bver) && revcomp(a:bver, b:"1.2.2")<0) {
    security_note(0, data:"Package up-imapproxy version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"pop3proxy");
if(!isnull(bver) && revcomp(a:bver, b:"1.1")<=0) {
    security_note(0, data:"Package pop3proxy version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
