#
#VID 9dda3ff1-2b02-11db-a6e2-000e0c2e438a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57253);
 script_cve_id("CVE-2006-2450");
 script_bugtraq_id(18977);
 script_version ("$");
 name = "FreeBSD Ports: x11vnc";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: x11vnc

CVE-2006-2450
auth.c in LibVNCServer 0.7.1 allows remote attackers to bypass
authentication via a request in which the client specifies an insecure
security type such as 'Type 1 - None', which is accepted even if it is
not offered by the server, a different issue than CVE-2006-2369.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://bugs.debian.org/376824
http://www.vuxml.org/freebsd/9dda3ff1-2b02-11db-a6e2-000e0c2e438a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: x11vnc";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"x11vnc");
if(!isnull(bver) && revcomp(a:bver, b:"0.8.2")<0) {
    security_note(0, data:"Package x11vnc version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
