#
#VID cad045c0-81a5-11d8-9645-0020ed76ef5a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52489);
 script_cve_id("CVE-2003-0858");
 script_version ("$");
 name = "FreeBSD Ports: zebra";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   zebra
   quagga

CVE-2003-0858
Zebra 0.93b and earlier, and quagga before 0.95, allows local users to
cause a denial of service by sending spoofed messages as other users
to the kernel netlink interface.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://rhn.redhat.com/errata/RHSA-2003-305.html
http://bugzilla.redhat.com/bugzilla/show_bug.cgi?id=107140
http://lists.quagga.net/pipermail/quagga-users/2003-November/000906.html
http://www.vuxml.org/freebsd/cad045c0-81a5-11d8-9645-0020ed76ef5a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: zebra";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"zebra");
if(!isnull(bver) && revcomp(a:bver, b:"0.93b_7")<0) {
    security_note(0, data:"Package zebra version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"quagga");
if(!isnull(bver) && revcomp(a:bver, b:"0.96.4")<0) {
    security_note(0, data:"Package quagga version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
