#
#ADV FreeBSD-SA-08:02.libc.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#
                                                                                
if(description)
{
 script_id(60187);
 script_cve_id("CVE-2008-0122");
 script_version ("$");
 name = "FreeBSD Security Advisory (FreeBSD-SA-08:02.libc.asc)";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-08:02.libc.asc

The resolver is the part of libc that resolves hostnames (example.com) to
internet protocol (IP) addresses (192.0.2.1) and vice versa.

The inet_network() function returns an in_addr_t representing the network
address of the IP address given to inet_network() as a character string in
the dot-notation.

An off-by-one error in the inet_network() function could lead to memory
corruption with certain inputs.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-08:02.libc.asc
Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Security Advisory (FreeBSD-SA-08:02.libc.asc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"6.2", patchlevel:"10")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
