#
#ADV FreeBSD-SA-08:10.nd6.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from ADV FreeBSD-SA-08:10.nd6.asc
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61702);
 script_cve_id("CVE-2008-2476");
 script_version ("$");
 name = "FreeBSD Security Advisory (FreeBSD-SA-08:10.nd6.asc)";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-08:10.nd6.asc

IPv6 nodes use the Neighbor Discovery protocol to determine the link-layer
address of other nodes, find routers, and maintain reachability information.
The Neighbor Discovery protocol uses Neighbor Solicitation (ICMPv6 type 135)
to query target nodes for their link-layer addresses.

IPv6 routers may allow on-link IPv6 nodes to create and update the
router's neighbor cache and forwarding information.  A malicious IPv6 node
sharing a common router but on a different physical segment from another
node may be able to spoof Neighbor Discovery messages, allowing it to update
router information for the victim node.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-08:10.nd6.asc
Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Security Advisory (FreeBSD-SA-08:10.nd6.asc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"7.0", patchlevel:"5")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"6.3", patchlevel:"5")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
