#
#ADV FreeBSD-SA-10:02.ntpd.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from ADV FreeBSD-SA-10:02.ntpd.asc
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66662);
 script_cve_id("CVE-2009-3563");
 script_version ("$Revision$");
 script_name("FreeBSD Security Advisory (FreeBSD-SA-10:02.ntpd.asc)");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-10:02.ntpd.asc

The ntpd(8) daemon is an implementation of the Network Time Protocol (NTP)
used to synchronize the time of a computer system to a reference time
source.

If ntpd receives a mode 7 (MODE_PRIVATE) request or error response
from a source address not listed in either a 'restrict ... noquery'
or a 'restrict ... ignore' section it will log the even and send
a mode 7 error response.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-10:02.ntpd.asc
Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Security Advisory (FreeBSD-SA-10:02.ntpd.asc)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"8.0", patchlevel:"2")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"7.2", patchlevel:"6")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"7.1", patchlevel:"10")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"6.4", patchlevel:"9")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"6.3", patchlevel:"15")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
