#
#ADV FreeBSD-SA-06:15.ypserv.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#
                                                                                
if(description)
{
 script_id(56851);
 script_cve_id("CVE-2006-2655");
 script_version ("$");
 name = "FreeBSD Security Advisory (FreeBSD-SA-06:15.ypserv.asc)";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-06:15.ypserv.asc

The ypserv(8) utility is a server which distributes NIS databases to client
systems within an NIS domain.

There are two documented methods of restricting access to NIS maps through
ypserv(8): through the use of the /var/yp/securenets file, and through the
/etc/hosts.allow file.  While both mechanisms are implemented in the server,
a change in the build process caused the securenets access restrictions
to be inadvertantly disabled.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-06:15.ypserv.asc
Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Security Advisory (FreeBSD-SA-06:15.ypserv.asc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"6.1", patchlevel:"1")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"6.0", patchlevel:"8")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"5.5", patchlevel:"1")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"5.4", patchlevel:"15")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"5.3", patchlevel:"30")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
