# kst-gpl
# This script was written by Michel Arboi <mikhail@nessus.org>
#
# GPL...
#

if(description)
{
 script_id(80064);;
 script_version ("$Revision: 1.1 $");
 script_name( "Fake FTP server does not accept any command");
 script_description(
"
Synopsis :

The remote FTP service is not working properly

Description :

The remote server advertises itself as being a a FTP server, but it does
not accept any command, which indicates that it may be a backdoor or a proxy. 

Further FTP tests on this port will be disabled to avoid false alerts.

Risk factor :

None
");
		 
 script_summary( "Checks that the FTP server accepts common commands");
 script_category(ACT_GATHER_INFO);
 script_family( "FTP");
 script_copyright("This script is Copyright (C) 2008 Michel Arboi");

 script_dependencie("find_service_3digits.nasl", "doublecheck_std_services.nasl", "logins.nasl");
 script_require_ports("Services/ftp", 21);
 script_require_keys("Settings/ExperimentalScripts");
 exit(0);
}

#
include('global_settings.inc');
include('misc_func.inc');
include('ftp_func.inc');

if (! experimental_scripts)
 exit(0);

login = get_kb_item("ftp/login");
pass = get_kb_item("ftp/password");
# if (! login) login = "anonymous";
# if (! pass) pass = "bounce@nessus.org";

port = get_kb_item("Services/ftp");
if (! port) port = 21;

if (! get_port_state(port)) exit(0);

soc = open_sock_tcp(port);
if (! soc) exit(0);

r = ftp_recv_line(socket: soc, retry: 3);
if (! r)
{
  debug_print('No FTP welcome banner on port ', port, '\n');
## set_kb_item(name: 'ftp/'+port+'/broken', value: TRUE);
  set_kb_item(name: 'ftp/'+port+'/no_banner', value: TRUE);
  ftp_close(socket: soc);
  return NULL;
}
debug_print(level: 2, 'Banner = ', r);

if (r =~ '^[45][0-9][0-9] ' || 
     match(string: r, pattern: 'Access denied*', icase: 1))
{
  log_print(level: 1, 'FTP server on port ', port, ' is closed\n');
  set_kb_item(name: 'ftp/'+port+'/denied', value: TRUE);
  ftp_close(socket: soc);
  exit(0);
}

foreach cmd (make_list("HELP", "USER ftp"))
# Not QUIT, as some servers close the connection without a 2xx code
{
 send(socket: soc, data: cmd + '\r\n');
 r = ftp_recv_line(socket: soc, retry: 3);
 if (r !~ '[1-5][0-9][0-9][ -]')
 {
   debug_print('FTP server on port ', port, ' answer to ', cmd, ': ', r);
   security_note(port: port);
   set_kb_item(name: 'ftp/'+port+'/broken', value: TRUE);
   close(soc);
   exit(0);
 }
 debug_print(level:2, 'FTP server on port ', port, ' answer to ', cmd, ': ', r);
}

close(soc);
