###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_flash_cs3_swf_proc_bof_vuln.nasl 368 2008-10-21 15:35:47Z oct $
#
# Adobe Flash CS3 SWF Processing Buffer Overflow Vulnerabilities
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800035);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4473");
  script_bugtraq_id(31769);
  script_name("Adobe Flash CS3 SWF Processing Buffer Overflow Vulnerabilities");
  desc = "

  Overview: This host is installed with Adobe Flash CS3 and is prone to buffer
  overflow vulnerabilities.

  Vulnerability Insight:
  The issues are caused due to boundary errors while processing overly long SWF
  control parameters.

  Impact:
  Successful exploitation could allow remote attackers to cause heap based
  buffer overflows via specially crafted SWF files.

  Impact Level: Application

  Affected Software/OS:
  Adobe Flash CS3 Professional on Windows.

  Fix: Upgrade to Adobe Flash CS4 Professional
  http://www.adobe.com/downloads/

  References:
  http://www.adobe.com/support/security/advisories/apsa08-09.html

  CVSS Score:
    CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Adobe Flash Creative Suite");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

uninstall = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
keys = registry_enum_keys(key:uninstall);
foreach key (keys)
{
  adobeName = registry_get_sz(key:uninstall + key, item:"DisplayName");
  if("Adobe Flash CS3 Professional" >< adobeName){
    security_hole(0);
  }
}
