###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_flash_player_mult_vuln_nov08_lin.nasl 457 2008-11-11 13:41:13Z oct $
#
# Adobe Flash Player Multiple Vulnerabilities - Nov08 (Linux)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800055);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4818", "CVE-2008-4819", "CVE-2008-4820", "CVE-2008-4821",
                "CVE-2008-4822", "CVE-2008-4823", "CVE-2008-4824", "CVE-2008-5361",
                "CVE-2008-5362", "CVE-2008-5363");
  script_bugtraq_id(32129);
  script_name("Adobe Flash Player Multiple Vulnerabilities - Nov08 (Linux)");
  desc = "
  Overview: This host has Adobe Flash Player installed and is prone to
  multiple security bypass vulnerabilities.

  Vulnerability Insight:
  Multiple flaws are reported in Adobe Flash Player, for more information
  refer,
  http://www.adobe.com/support/security/bulletins/apsb08-20.html
  http://www.adobe.com/support/security/bulletins/apsb08-22.html

  Impact: Successful attack could allow malicious people to bypass certain
  security restrictions or manipulate certain data.

  Impact Level: Application

  Affected Software/OS:
  Adobe Flash Player 9.0.124.0 and earlier on Linux.

  Fix: Upgrade to Adobe Flash Player 9.0.151.0 or 10.0.12.36,
  http://www.adobe.com/downloads/

  References:
  http://www.adobe.com/support/security/bulletins/apsb08-20.html
  http://www.adobe.com/support/security/bulletins/apsb08-22.html

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Adobe Flash Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_adobe_flash_player_detect_lin.nasl");
  exit(0);
}


include("version_func.inc");

adobeVer = get_kb_item("AdobeFlashPlayer/Linux/Ver");
if(!adobeVer){
  exit(0);
}

# Check for version 9.0.124.0 and prior
if(version_is_less_equal(version:adobeVer, test_version:"9.0.124.0")){
  security_hole(0);
}
