###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_prdts_media_obj_heap_spray_vuln_dec09_lin.nasl 6219 2009-12-15 10:30:34Z dec $
#
# Adobe Reader/Acrobat Multimeda Doc.media.newPlayer Remote Code Execution Vulnerability (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801095);
  script_version("$Revision: 6233 $: 1.0");
  script_cve_id("CVE-2009-4324");
  script_bugtraq_id(37331);
  script_name("Adobe Reader/Acrobat Multimeda Doc.media.newPlayer Remote Code Execution Vulnerability (Linux)");
  desc = "
  Overview: This host is installed with Adobe Reader and is prone to
  Doc.media.newPlayer Remote Code Execution vulnerability.

  Vulnerability Insight:
  There exists a flaw in the JavaScript module doc.media object while sending
  a null argument to the newPlayer() method as the exploitation method makes
  use of a vpointer that has not been initialized.

  Impact Level: System

  Affected Software/OS:
  Adobe Reader version 9.2.0 and prior.

  Workaround:
  Disable JavaScript execution from the Adobe Acrobat/Reader product
  configuration menu settings.

  Fix:
  No solution or patch is available as on 15th December, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.adobe.com

  References:
  http://www.f-secure.com/weblog/archives/00001836.html
  http://extraexploit.blogspot.com/search/label/CVE-2009-4324
  http://www.shadowserver.org/wiki/pmwiki.php/Calendar/20091214
  http://blogs.adobe.com/psirt/2009/12/new_adobe_reader_and_acrobat_v.html
  http://downloads.securityfocus.com/vulnerabilities/exploits/adobe_media_newplayer.rb
  http://vrt-sourcefire.blogspot.com/2009/12/adobe-reader-medianewplayer-analysis.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Adobe Reader");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_adobe_prdts_detect_lin.nasl");
  script_require_keys("Adobe/Reader/Linux/Version", "");
  exit(0);
}


include("version_func.inc");

readerVer = get_kb_item("Adobe/Reader/Linux/Version");
if(readerVer != NULL)
{
  # Check for Adobe Reader version 9.2.0 and prior
  if(version_is_less_equal(version:readerVer, test_version:"9.2.0")){
    security_hole(0);
  }
}
