###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_prdts_mult_vuln_dec09_win.nasl 6183 2009-12-11 12:24:34Z dec $
#
# Adobe Flash Player/Air Multiple Vulnerabilities - dec09 (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801083);
  script_version("$Revision: 6162 $");
  script_cve_id("CVE-2009-3794", "CVE-2009-3796", "CVE-2009-3797", "CVE-2009-3798",
                "CVE-2009-3799", "CVE-2009-3800", "CVE-2009-3951");
  script_bugtraq_id(37266, 37270, 37273, 37275, 37267, 37269, 37272 );
  script_name("Adobe Flash Player/Air Multiple Vulnerabilities - dec09 (Win)");
  desc = "
  Overview: This host is installed with Adobe Flash Player/Air and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  The multiple Flaws are due to:
  - An error occured while parsing JPEG dimensions contained within an SWF file
    can be exploited to cause a heap-based buffer overflow.
  - An unspecified error may allow injection of data and potentially lead to
    execution of arbitrary code.
  - An unspecified error possibly related to 'getProperty()' can be exploited
    to corrupt memory and may allow execution of arbitrary code.
  - An unspecified error can be exploited to corrupt memory and may allow
    execution of arbitrary code.
  - An integer overflow error when generating ActionScript exception handlers
    in 'Verifier::parseExceptionHandlers()' can be exploited to corrupt memory.
  - Various unspecified errors may potentially allow execution of arbitrary code.
  - An error may disclose information about local file names.

  Impact:
  Successful exploitation will let the remote attackers to execute arbitrary code,
  gain elevated privileges, gain knowledge of certain information and conduct
  clickjacking attacks.

  Impact Level: System/Application

  Affected Software/OS:
  Adobe AIR version prior to 1.5.3
  Adobe Flash Player 10 version prior to 10.0.42.34 on Windows

  Fix: Update to Adobe Air 1.5.3 or Adobe Flash Player 10.0.42.34
  http://get.adobe.com/air
  http://www.adobe.com/support/flashplayer/downloads.html

  References:
  http://secunia.com/advisories/37584
  http://www.vupen.com/english/advisories/2009/3456
  http://www.adobe.com/support/security/bulletins/apsb09-19.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Adobe Flash Player/Air");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("General");
  script_dependencies("gb_adobe_flash_player_detect_win.nasl");
  script_require_keys("AdobeFlashPlayer/Win/Ver", "Adobe/Air/Win/Ver");
  script_require_ports(139, 445);
  exit(0);
}


include("version_func.inc");

# Check for Adobe Flash Player
playerVer = get_kb_item("AdobeFlashPlayer/Win/Ver");
if(playerVer != NULL)
{
  # Grep for version 10.x < 10.0.32.18
  if(version_in_range(version:playerVer, test_version:"10.0", test_version2:"10.0.42.33")) {
    security_hole(0);
  }
}

# Check for Adobe Air
airVer = get_kb_item("Adobe/Air/Win/Ver");
if(airVer != NULL)
{
  # Grep for version < 1.5.3
  if(version_is_less(version:airVer, test_version:"1.5.3")){
    security_hole(0);
  }
}
