###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_prdts_mult_vuln_oct09_lin.nasl 5286 2009-10-21 12:55:09Z oct $
#
# Adobe Reader Multiple Vulnerabilities - Oct09 (Linux)
#
# Authors:
# Nikta MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800958);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2009-2979", "CVE-2009-2980", "CVE-2009-2981", "CVE-2009-2982",
                "CVE-2009-2983", "CVE-2009-2984", "CVE-2009-2985", "CVE-2009-2986",
                "CVE-2009-2987", "CVE-2009-2988", "CVE-2009-2989", "CVE-2009-2990",
                "CVE-2009-2991", "CVE-2009-2992", "CVE-2009-2993", "CVE-2009-2994",
                "CVE-2009-2995", "CVE-2009-2996", "CVE-2009-2997", "CVE-2009-2998",
                "CVE-2009-3458", "CVE-2009-3459", "CVE-2009-3460", "CVE-2009-3462");
  script_bugtraq_id(36686, 36687, 36688, 36691, 36667, 36690, 36680, 36682, 36693,
                    36665, 36669, 36689, 36694, 36681, 36671, 36678, 36677, 36600,
                    36638, 36696);
  script_name("Adobe Reader Multiple Vulnerabilities - Oct09 (Linux)");
  desc = "
  Overview : This host has Adobe Reader installed which is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  For more information about the vulnerabilities refer the links mentioned in
  references.

  Impact:
  Successful exploitation allows remote attackers to execute arbitrary code,
  write arbitrary files or folders to the filesystem, escalate local privileges,
  or cause a denial of service on an affected system by tricking the user to
  open a malicious PDF document.

  Impact Level: Application/System

  Affected Software/OS:
  Adobe Reader version 7.x before 7.1.4, 8.x before 8.1.7 and 9.x before 9.2
  on Linux.

  Fix:
  Upgrade to Adobe Reader versions 9.2, 8.1.7, or 7.1.4
  For Updates Refer, http://www.adobe.com/downloads/

  References:
  http://secunia.com/advisories/36983
  http://xforce.iss.net/xforce/xfdb/53691
  http://www.vupen.com/english/advisories/2009/2851
  http://www.vupen.com/english/advisories/2009/2898
  http://securitytracker.com/alerts/2009/Oct/1023007.html
  http://www.adobe.com/support/security/bulletins/apsb09-15.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Adobe Reader");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_adobe_prdts_detect_lin.nasl");
  script_require_keys("Adobe/Reader/Linux/Version");
  exit(0);
}


include("version_func.inc");

# Check for Adobe Reader version prior to 9.2 or 8.1.7 or 7.1.4
readerVer = get_kb_item("Adobe/Reader/Linux/Version");
if(readerVer)
{
  if(version_in_range(version:readerVer, test_version:"7.0", test_version2:"7.1.3")||
     version_in_range(version:readerVer, test_version:"8.0", test_version2:"8.1.6")||
     version_in_range(version:readerVer, test_version:"9.0", test_version2:"9.1.3")){
    security_hole(0);
  }
}
