###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_robohelp_server_unspecified_vuln.nasl 4515 2009-09-08 14:47:17Z sep $
#
# Adobe RoboHelp Server Unspecified Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801103);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3068");
  script_bugtraq_id(36245);
  script_name("Adobe RoboHelp Server Unspecified Vulnerability");
  desc = "
  Overview:
  This host is running Adobe RoboHelp Server and is prone to unspecified
  vulnerability.

  Vulnerability Insight:
  The flaw is caused due to an unspecified 'pre-authentication' error
  which can be exploited via unknown vectors.

  Impact:
  Successful exploitation could allow attackers to execute arbitrary code or
  compromise a vulnerable system.

  Impact Level: Application

  Affected Software/OS:
  Adobe RoboHelp Server version 8.0

  Fix: No solution or patch is available as on 08th September, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.adobe.com/

  References:
  http://intevydis.com/vd-list.shtml
  http://www.intevydis.com/blog/?p=26
  http://secunia.com/advisories/36467
  http://blogs.adobe.com/psirt/2009/09/potential_robohelp_server_8_is.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Adobe RoboHelp Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_adobe_robohelp_server_detect.nasl");
  script_require_ports("Services/www", 8080);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

robohelpPort = get_http_port(default:8080);
if(!robohelpPort)
{
  exit(0);
}

robohelpVer = get_kb_item("www/" + robohelpPort + "/RoboHelpServer");
robohelpVer = eregmatch(pattern:"^(.+) under (/.*)$", string:robohelpVer);

if(robohelpVer[1] != NULL)
{
  if(version_is_equal(version:robohelpVer[1], test_version:"8.0")){
    security_warning(robohelpPort);
  }
}
