###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_alleycode_html_editor_detect.nasl 5352 2009-10-23 19:21:29Z oct $
#
# Alleycode HTML Editor Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801126);
  script_version("$Revision: 1.0 $");
  script_name("Alleycode HTML Editor Version Detection");
  desc = "
  Overview: This script detects the installed version of Alleycode HTML Editor
  and sets the result in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of Alleycode HTML Editor");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

aheName = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                              "\Uninstall\Kobeman_is1", item:"DisplayName");

if("Alleycode HTML Editor" >< aheName)
{
  aheVer = eregmatch(pattern:"Alleycode HTML Editor ([0-9.]+)", string:aheName);
  if(aheVer[1]){
    set_kb_item(name:"Alleycode-HTML-Editor/Ver", value:aheVer[1]);
  }
}
