###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apple_quicktime_bof_vuln.nasl 654 2008-12-18 17:25:12Z dec $
#
# Apple QuickTime Malformed .mov File Buffer Overflow Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800319);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5406");
  script_bugtraq_id(32540);
  script_name("Apple QuickTime Malformed .mov File Buffer Overflow Vulnerability");
  desc = "

  Overview: This host has QuickTime installed, which is prone to Buffer Overflow
  Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to a failure in handling long arguments on a .mov file.

  Impact:
  Successful exploitation could allow the attacker execution of arbitrary codes
  in the context of the affected application and can perform denial of service.

  Impact Level: Application

  Affected Software/OS:
  Apple QuickTime version 7.5.5 on Windows.

  Fix: No solution or patch is available as on 18th December, 2008. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.apple.com/

  References:
  http://www.milw0rm.com/exploits/7296
  http://xforce.iss.net/xforce/xfdb/46984

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Apple QuickTime");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_reg_enum.nasl",
                      "secpod_apple_quicktime_detection_win_900124.nasl");
  exit(0);
}


if(get_kb_item("QuickTime/Win/Ver") =~ "^7\.5\.5$"){
  security_hole(0);
}
