###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apple_quicktime_mult_vuln_jun09.nasl 2614 2009-06-03 10:53:46Z june $
#
# Apple QuickTime Multiple Vulnerabilities - Jun09
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800578);
  script_version("$Revision: 1.1 $");
  script_cve_id("CVE-2009-0951","CVE-2009-0952","CVE-2009-0953",
                "CVE-2009-0954","CVE-2009-0955","CVE-2009-0956",
                "CVE-2009-0957","CVE-2009-0185","CVE-2009-0188");
  script_bugtraq_id(35161, 35168, 35164, 35167, 35166, 35162, 35165, 35163, 35159);
  script_name("Apple QuickTime Multiple Vulnerabilities - Jun09");
  desc = "

  Overview : The host is installed with Apple QuickTime which is prone to
  Multiple Vulnerabilities.

  Vulnerability Insight:
  The flaws are caused due to,
  - an unspecified error while handling malicious 1)FLC compression files,
    2)compressed PSD images, 3)PICT images, 4)JP2 images.
  - an error in the parsing of Sorenson Video 3 content.
  - a boundary error in the processing of MS ADPCM encoded audio data.
  - an error due to the usage of uninitialised memory when a movie with a
    user data atom size of zero is viewed.
  - a sign extension error while the handling malicious image description
    atoms in an Apple video file.

  Impact : Successful exploitation allow attackers to execute arbitrary code,
  cause memory corruption or unexpected application termination via specially
  crafted files, images and videos.

  Impact Level : Application

  Affected Software/OS:
  Apple QuickTime version prior to 7.6.2 on Windows.

  Fix : Upgrade to Apple QuickTime version 7.6.2 or later,
  http://www.apple.com/quicktime/download/

  References :
  http://secunia.com/advisories/35091
  http://lists.apple.com/archives/security-announce/2009/Jun/msg00000.html

  CVSS Score :
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Apple QuickTime");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_apple_quicktime_detection_win_900124.nasl");
  script_require_keys("QuickTime/Win/Ver");
  exit(0);
}


include("version_func.inc");

quicktimeVer = get_kb_item("QuickTime/Win/Ver");
if(!quicktimeVer){
  exit(0);
}

# Grep for QuickTime version <= 7.6.2
if(version_is_less(version:quicktimeVer, test_version:"7.6.2")){
  security_hole(0);
}
