###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apple_quicktime_mult_vuln_win.nasl 0284 2008-09-25 10:53:46Z sep $
#
# Apple QuickTime Multiple Arbitrary Code Execution Vulnerabilities (Win)
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800102);
  script_version("$Revision: 1.1 $");
  script_cve_id("CVE-2008-1581","CVE-2008-1582","CVE-2008-1583",
                "CVE-2008-1584","CVE-2008-1585");
  script_bugtraq_id(29619);
  script_xref(name:"CB-A", value:"08-0094");
  script_name("Apple QuickTime Multiple Arbitrary Code Execution Vulnerabilities (Win)");
  desc = "

  Overview : The host is installed with Apple QuickTime which is prone to
  Multiple Arbitrary Code Execution Vulnerabilities.

  Vulnerability Insight:

  The flaws are caused due to,
  - boundary error when parsing packed scanlines from a PixData
    structure in a PICT file which can be exploited via specially crafted
    PICT file.
  - memory corruption issue in AAC-encoded media content can be
    exploited via a specially crafted media file.
  - error in the handling of PICT files or Indeo video codec content that
    can be exploited via a specially crafted PICT file or movie file with
    Indeo video codec content respectively.
  - error in the handling of file URLs that can be exploited by making user
    to play maliciously crafted QuickTime content.

  Impact : Successful exploitation allow attackers to execute arbitrary
  code or unexpected application termination.

  Impact Level : Application

  Affected Software/OS:
  Apple QuickTime before 7.5 on Windows (Any).

  Fix : Upgrade to Apple QuickTime version 7.5 or later,
  http://www.apple.com/quicktime/download/

  References :
  http://support.apple.com/kb/HT1991
  http://secunia.com/advisories/29293
  http://www.nruns.com/security_advisory_quicktime_arbitrary_code_execution.php

  CVSS Score :
    CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
    CVSS Temporal Score : 6.1
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Apple QuickTime");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_apple_quicktime_detection_win_900124.nasl");
  exit(0);
}


# Grep for QuickTime version <= 7.5
if(egrep(pattern:"^([0-6]\..*|7\.([0-4](\..*)?))$",
         string:get_kb_item("QuickTime/Win/Ver"))){
  security_hole(0);
}
