###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_awstats_xss_vuln.nasl 589 2008-12-05 12:28:51Z dec $
#
# AWStats awstats.pl XSS Vulnerability - Dec08
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800151);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2008-5080 ");
  script_name("AWStats awstats.pl XSS Vulnerability - Dec08");
  desc = "

  Overview: The host is running AWStats, which is prone to XSS Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to query_string parameter in awstats.pl which is not
  properly sanitized before being returned to the user.

  Impact: Successful attack could lead to execution of arbitrary HTML and
  script code in the context of an affected site.

  NOTE: This issue exists because of an incomplete fix for CVE-2008-3714.

  Impact Level: Application

  Affected Software/OS:
  AWStats 6.8 and earlier.

  Fix: Update to higher Version or Apply patches from,
  http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=495432#21

  *****
  NOTE : Ignore this warning, if above mentioned patch is applied already.
  *****

  References:
  https://bugzilla.redhat.com/show_bug.cgi?id=474396
  http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=495432

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of AWStats");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Web application abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

foreach dir (make_list("/awstats/wwwroot/cgi-bin", cgi_dirs()))
{
  sndReq = http_get(item: dir + "/awstats.pl", port:port);
  rcvRes = http_keepalive_send_recv(port:port, data:sndReq, bodyonly:1);

  if(rcvRes == NULL){
    exit(0);
  }

  if("Advanced Web Statistics" >< rcvRes)
  {
    awVer = eregmatch(pattern:"AWStats ([0-9.]+)", string:rcvRes);
    if(awVer[1] != NULL && version_is_less_equal(version:awVer[1],
                                                 test_version:"6.8")){
     security_warning(port);
    }
    exit(0);
  }
}
