###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_clamav_jpeg_file_remote_dos_vuln.nasl 587 2008-12-09 15:04:56Z dec $
#
# ClamAV Remote Denial of Service Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800079);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2008-5314");
  script_bugtraq_id(32555);
  script_name("ClamAV Remote Denial of Service Vulnerability");
  desc = "

  Overview: This host has ClamAV installed, and is prone to denial of service
  vulnerability.

  Vulnerability Insight:
  The application fails to validate user input passed to cli_check_jpeg_exploit,
  jpeg_check_photoshop, and jpeg_check_photoshop_8bim functions in special.c file.

  Impact:
  Successful exploitation will cause remote attackers to crash the daemon via
  a specially crafted JPEG file.

  Impact Level: Application

  Affected Software/OS:
  ClamAV before 0.94.2 on Linux

  Fix: Upgrade to ClamAV 0.94.2
  http://www.clamav.net/

  References:
  http://www.openwall.com/lists/oss-security/2008/12/01/8
  http://lurker.clamav.net/message/20081126.150241.55b1e092.en.html

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of ClamAV");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

getPath = find_bin(prog_name:"clamscan", sock:sock);
foreach binaryFile (getPath)
{
  avVer = get_bin_version(full_prog_name:chomp(binaryFile), version_argv:"-V",
                          ver_pattern:"ClamAV ([0-9.]+)", sock:sock);
  if(avVer[1] != NULL)
  {
    # Check for < 0.94.2 version of ClamAV
    if(version_is_less(version:avVer[1], test_version:"0.94.2")){
      security_hole(0);
    }
    ssh_close_connection(); # If version is found and not vulnerable, close and exit
    exit(0);
  }
}
ssh_close_connection();
