###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_cups_lppasswd_sec_bypass_vuln.nasl 7600 2010-03-10 17:20:36Z mar $
#
# CUPS 'lppasswd' Tool Localized Message String Security Bypass Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800488);
  script_version("$Revision: 6941 $: 1.0");
  script_cve_id("CVE-2010-0393");
  script_bugtraq_id(38524);
  script_name("CUPS 'lppasswd' Tool Localized Message String Security Bypass Vulnerability");
  desc = "
  Overview: This host is running CUPS (Common UNIX Printing System) Service,
  which is prone to security bypass vulnerability.

  Vulnerability Insight:
  The flaw is caused due to error within the '_cupsGetlang()' function, as used
  by 'lppasswd.c' in 'lppasswd', relies on an environment variable to determine
  the file that provides localized message strings.

  Impact:
  Successful exploitation allows remote attackers to gain privileges via a file
  that contains crafted localization data with format string specifiers.

  Impact Level: Application

  Affected Software/OS:
  CUPS versions 1.2.x, 1.3.x, 1.4.x on Linux.

  Fix: No solution or patch is available as on 10th March, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.cups.org/software.php

  References:
  http://www.ubuntu.com/usn/USN-906-1
  https://bugzilla.redhat.com/show_bug.cgi?id=558460

  CVSS Score:
    CVSS Base Score       : 6.9 (AV:L/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score   : 5.9
  Risk factor  : High";

  script_description(desc);
  script_summary("Check for the version of CUPS Service");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("General");
  script_dependencies("secpod_cups_detect.nasl");
  script_require_ports("Services/www", 631);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

cupsPort = get_http_port(default:631);
if(!cupsPort){
  exit(0);
}

cupsVer = get_kb_item("www/"+ cupsPort + "/CUPS");
if(!cupsVer){
  exit(0);
}

if(cupsVer != NULL)
{
  # Check for CUPS version 1.2.x and 1.3.x, 1.4.x
  if(version_in_range(version:cupsVer, test_version:"1.4.0", test_version2:"1.4.1" ) ||
     version_in_range(version:cupsVer, test_version:"1.2.0", test_version2:"1.2.2" ) ||
     version_in_range(version:cupsVer, test_version:"1.3.0", test_version2:"1.3.10")){
    security_hole(cupsPort);
  }
}
