###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_cuteftp_bof_vuln.nasl 5124 2009-10-16 15:27:05Z oct $
#
# CuteFTP Heap Based Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800948);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3483");
  script_name("CuteFTP Heap Based Buffer Overflow Vulnerability");
  desc = "
  Overview: The host is installed with CuteFTP and is prone to buffer overflow
  vulnerability.

  Vulnerability Insight:
  The flaw is caused due to error in 'Create New Site' feature when connecting
  to sites having an overly long label. This can be exploited to corrupt heap
  memory by tricking a user into importing a malicious site list and connecting
  to a site having an overly long label.

  Impact:
  Successful exploitation will allow remote attackers to execute arbitrary code
  and potentially compromise a user's system.

  Impact Level: System/Application

  Affected Software/OS:
  CuteFTP Home/Pro/Lite 8.3.3, 8.3.3.54 on Windows.

  Fix:
  No solution or patch is available as on 15th October, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.cuteftp.com/downloads/

  References:
  http://secunia.com/advisories/36874
  http://xforce.iss.net/xforce/xfdb/53487
  http://www.packetstormsecurity.org/0909-exploits/Dr_IDE-CuteFTP_FTP_8.3.3-PoC.py.txt

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of CuteFTP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_cuteftp_detect.nasl");
  exit(0);
}


include("version_func.inc");

cVer = make_list();

chVer = get_kb_item("CuteFTP/Home/Ver");
if(!isnull(chVer)){
  cVer = make_list(cVer, chVer);
}

clVer = get_kb_item("CuteFTP/Lite/Ver");
if(!isnull(clVer)){
  cVer = make_list(cVer,clVer);
}

cpVer = get_kb_item("CuteFTP/Professional/Ver");
if(!isnull(cpVer)){
  cVer = make_list(cVer,cpVer);
}

foreach ver (cVer)
{
  if(version_is_equal(version:ver, test_version:"8.3.3") ||
     version_is_equal(version:ver, test_version:"8.3.3.54"))
  {
    security_hole(0);
    exit(0);
  }
}
