##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_cuteftp_detect.nasl 5124 2009-10-16 10:05:35Z oct $
#
# CuteFTP Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800947);
  script_version("$Revision: 1.0 $");
  script_name("CuteFTP Version Detection");
  desc = "
  Overview : This script finds the installed CuteFTP version and saves the
  result in KB item.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set version of CuteFTP in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!(registry_key_exists(key:"SOFTWARE\GlobalSCAPE Inc.")||
     registry_key_exists(key:"SOFTWARE\GlobalSCAPE"))){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  cName = registry_get_sz(key:key + item, item:"DisplayName");
  cftpName = eregmatch(pattern:"CuteFTP [0-9.?]+ ([a-zA-Z]+)",string:cName);
  if(cftpName[1] != NULL)
  {
    cPath = registry_get_sz(key:key + item, item:"DisplayIcon");
    if(cPath == NULL){
      exit(0);
    }

    cPath = cPath - ",-0";
    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:cPath);
    file  = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:cPath);
    cftpVer = GetVer(share:share, file:file);
    if(!isnull(cftpVer)){
      set_kb_item(name:"CuteFTP/"+string(cftpName[1])+"/Ver", value:cftpVer);
    }
  }
}
