###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_document_manager_info_disc_vuln.nasl 7274 2010-02-18 11:43:17Z feb $
#
# Document Manager Information Disclosure Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800478);
  script_version("$Revision: 6804 $: 1.0");
  script_cve_id("CVE-2010-0612");
  script_name("Document Manager Information Disclosure Vulnerability");
  desc = "
  Overview: The host is running Document Manager and is prone to Information
  Disclosure vulnerability.

  Vulnerability Insight:
  The flaw is caused due to an unspecified error related to file rights.

  Impact:
  Successful exploitation will allow remote attackers to obtain sensitive
  information.

  Impact Level: Application

  Affected Software/OS:
  Document Manager version prior to 4.0

  Fix: Upgrade Document Manager version to 4.0
  For updates refer, http://www.dmanager.org/download.php.en

  References:
  http://osvdb.org/62032
  http://secunia.com/advisories/38441
  http://freshmeat.net/projects/dmanager/releases/311735

  CVSS Score:
    CVSS Base Score      : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 5.5
  Risk factor : High";

  script_description(desc);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_summary("Check for the version of Document Manager");
  script_category(ACT_GATHER_INFO);
  script_family("Web application abuses");
  script_dependencies("gb_document_manager_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

dmport = get_http_port(default:80);
if(!dmport){
  exit(0);
}

dmver = get_kb_item("www/" + dmport + "/DocManager");
if(isnull(dmver)){
  exit(0);
}

dmver = eregmatch(pattern:"^(.+) under (/.*)$", string:dmver);
if(!isnull(dmver[1]))
{
  #  Document Manager version < 4.0
  if(version_is_less(version:dmver[1], test_version:"4.0")){
    security_hole(dmport);
  }
}
