###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_dokuwiki_mult_csrf_vuln.nasl 7296 2010-02-18 12:33:29 feb $
#
# DokuWiki Multiple Cross Site Request Forgery Vulnerabilities
#
# Authors:
# Rachana Shetty <srachan@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800989);
  script_version("$Revision: 6788 $: 1.0");
  script_cve_id("CVE-2010-0289");
  script_name("DokuWiki Multiple Cross Site Request Forgery Vulnerabilities");
  desc = "
  Overview: This host is installed with Dokuwiki and is prone to multiple Cross
  Site Scripting vulnerabilities.

  Vulnerability Insight:
  The flaws are due to error in 'ACL' Manager plugin (plugins/acl/ajax.php) that
  allows users to perform certain actions via HTTP requests without performing
  any validity checks.

  Impact:
  Successful exploitation allows attackers to conduct cross site request
  forgery attacks via unknown vectors.

  Impact Level: Application.

  Affected Software/OS:
  Dokuwiki versions prior to 2009-12-25c

  Fix: Update to version 2009-12-25c or later.
  For Updates Refer, http://www.splitbrain.org/go/dokuwiki

  References:
  http://secunia.com/advisories/38205
  http://www.vupen.com/english/advisories/2010/0150
  http://bugs.splitbrain.org/index.php?do=details&task_id=1853

  CVSS Score:
    CVSS Base Score      : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 5.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of DokuWiki");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_dependencies("gb_dokuwiki_detect.nasl");
  script_family("Web application abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

dokuwikiPort = get_http_port(default:80);
if(!dokuwikiPort){
  exit(0);
}

# check Version from KB
dokuVer = get_kb_item("www/" + dokuwikiPort + "/DokuWiki");
if(isnull(dokuVer)){
  exit(0);
}

dokuVer = eregmatch(pattern:"^(.+) under (/.*)$", string:dokuVer);
if(dokuVer[1] != NULL)
{
  # Check for version less then 2009-12-25c
  if(version_is_less(version:dokuVer[1], test_version:"2009.12.25c")){
    security_hole(dokuwikiPort);
  }
}
