###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_dotnetnuke_skin_sec_bypass_vuln.nasl 4254 2009-09-02 19:06:24Z sep $
#
# DotNetNuke Skin Files Security Bypass Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#######################################`########################################

if(description)
{
  script_id(800685);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2008-7102");
  script_bugtraq_id(31145);
  script_name("DotNetNuke Skin Files Security Bypass Vulnerability");
  desc = "
  Overview: The host is installed with DotNetNuke and is prone to security
  bypass vulnerability.

  Vulnerability Insight:
  The vulnerability is caused due improper validation of user data passed
  via unspecified parameters before being used to load skin files.

  Impact:
  Successful exploitation could allows remote attackers to gain administrative
  privileges or compromise the affected system.

  Impact Level: Application

  Affected Software/OS:
  DotNetNuke versions 2.0 to 4.8.4.

  Fix: Upgrade to DotNetNuke version 4.9.0 or latest
  For Updates Refer, http://www.dotnetnuke.com/

  References:
  http://xforce.iss.net/xforce/xfdb/45077
  http://www.dotnetnuke.com/News/SecurityPolicy/Securitybulletinno23/tabid/1176/Default.aspx

  CVSS Score:
    CVSS Base Score      : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 5.5
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of DotNetNuke");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_dotnetnuke_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

dnnPort = get_http_port(default:80);
if(!dnnPort){
  exit(0);
}

dnnVer = get_kb_item("www/" + dnnPort + "/DotNetNuke");
if(!dnnVer){
  exit(0);
}

dnnVer = eregmatch(pattern:"^(.+) under (/.*)$", string:dnnVer);
if(dnnVer[1] != NULL)
{
  if(version_in_range(version:dnnVer[1], test_version:"2.0", test_version2:"4.8.4")){
    security_hole(dnnPort);
  }
}
