###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for HelixPlayer FEDORA-2007-0756
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861058);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-0756");
  script_cve_id("CVE-2007-3410");
  script_name( "Fedora Update for HelixPlayer FEDORA-2007-0756");
  desc = "

  Vulnerability Insight:
  Helix Player is an open-source media player built in the Helix
  Community for consumers. Built using GTK, it plays open source formats,
  like Ogg Vorbis and Theora using the powerful Helix DNA Client Media
  Engine.


  Affected Software/OS:
  HelixPlayer on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-June/msg00666.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of HelixPlayer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"HelixPlayer", rpm:"HelixPlayer~1.0.7~6.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"HelixPlayer-plugin", rpm:"HelixPlayer-plugin~1.0.7~6.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"HelixPlayer-debuginfo", rpm:"HelixPlayer-debuginfo~1.0.7~6.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"HelixPlayer", rpm:"HelixPlayer~1.0.7~6.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}