###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for tcpdump FEDORA-2007-1361
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861211);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-1361");
  script_cve_id("CVE-2007-3798");
  script_name( "Fedora Update for tcpdump FEDORA-2007-1361");
  desc = "

  Vulnerability Insight:
  Tcpdump is a command-line tool for monitoring network traffic.
  Tcpdump can capture and display the packet headers on a particular
  network interface or on all interfaces.  Tcpdump can display all of
  the packet headers, or just the ones that match particular criteria.
  
  Install tcpdump if you need a program to monitor network traffic.


  Affected Software/OS:
  tcpdump on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-July/msg00563.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of tcpdump");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"tcpdump", rpm:"tcpdump~3.9.7~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tcpdump", rpm:"tcpdump~3.9.7~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tcpdump-debuginfo", rpm:"tcpdump-debuginfo~3.9.7~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tcpdump", rpm:"tcpdump~3.9.7~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tcpdump-debuginfo", rpm:"tcpdump-debuginfo~3.9.7~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}