###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for balsa FEDORA-2007-1447
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861480);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-1447");
  script_cve_id("CVE-2007-1558");
  script_name( "Fedora Update for balsa FEDORA-2007-1447");
  desc = "

  Vulnerability Insight:
  Balsa is a GNOME email client which supports mbox, maildir, and mh
  local mailboxes, and IMAP4 and POP3 remote mailboxes. Email can be
  sent via sendmail or SMTP. Optional multithreading support allows for
  non-intrusive retrieval and sending of mail. A finished GUI similar to
  that of the Eudora email client supports viewing images inline, saving
  message parts, viewing headers, adding attachments, moving messages,
  and printing messages.


  Affected Software/OS:
  balsa on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-August/msg00086.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of balsa");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"balsa", rpm:"balsa~2.3.17~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"balsa-debuginfo", rpm:"balsa-debuginfo~2.3.17~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"balsa", rpm:"balsa~2.3.17~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"balsa", rpm:"balsa~2.3.17~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"balsa-debuginfo", rpm:"balsa-debuginfo~2.3.17~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}