###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for tetex FEDORA-2007-1547
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861410);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-1547");
  script_cve_id("CVE-2007-3387");
  script_name( "Fedora Update for tetex FEDORA-2007-1547");
  desc = "

  Vulnerability Insight:
  TeTeX is an implementation of TeX for Linux or UNIX systems. TeX takes
  a text file and a set of formatting commands as input and creates a
  typesetter-independent .dvi (DeVice Independent) file as output.
  Usually, TeX is used in conjunction with a higher level formatting
  package like LaTeX or PlainTeX, since TeX by itself is not very
  user-friendly. The output format needn't to be DVI, but also PDF,
  when using pdflatex or similar tools.
  
  Install tetex if you want to use the TeX text formatting system. Consider
  to install tetex-latex (a higher level formatting package which provides
  an easier-to-use interface for TeX). Unless you are an expert at using TeX,
  you should also install the tetex-doc package, which includes the
  documentation for TeX.


  Affected Software/OS:
  tetex on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-August/msg00168.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of tetex");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"tetex", rpm:"tetex~3.0~40.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-fonts", rpm:"tetex-fonts~3.0~40.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-debuginfo", rpm:"tetex-debuginfo~3.0~40.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-afm", rpm:"tetex-afm~3.0~40.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-latex", rpm:"tetex-latex~3.0~40.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-doc", rpm:"tetex-doc~3.0~40.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex", rpm:"tetex~3.0~40.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-dvips", rpm:"tetex-dvips~3.0~40.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-xdvi", rpm:"tetex-xdvi~3.0~40.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-fonts", rpm:"tetex-fonts~3.0~40.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-afm", rpm:"tetex-afm~3.0~40.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-dvips", rpm:"tetex-dvips~3.0~40.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex", rpm:"tetex~3.0~40.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-xdvi", rpm:"tetex-xdvi~3.0~40.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-latex", rpm:"tetex-latex~3.0~40.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-doc", rpm:"tetex-doc~3.0~40.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"tetex-debuginfo", rpm:"tetex-debuginfo~3.0~40.1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}