###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for ntfs-3g FEDORA-2007-2295
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861297);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-2295");
  script_cve_id("");
  script_name( "Fedora Update for ntfs-3g FEDORA-2007-2295");
  desc = "

  Vulnerability Insight:
  The ntfs-3g driver is an open source, GPL licensed, third generation
  Linux NTFS driver. It provides full read-write access to NTFS, excluding
  access to encrypted files, writing compressed files, changing file
  ownership, access right.
  
  Technically its based on and a major improvement to the third
  generation Linux NTFS driver, ntfsmount. The improvements include
  functionality, quality and performance enhancements.
  
  ntfs-3g features are being merged to ntfsmount. In the meanwhile,
  ntfs-3g is currently the only free, as in either speech or beer, NTFS
  driver for Linux that supports unlimited file creation and deletion.


  Affected Software/OS:
  ntfs-3g on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-September/msg00368.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of ntfs-3g");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"ntfs-3g", rpm:"ntfs-3g~1.913~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ntfs-3g", rpm:"ntfs-3g~1.913~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ntfs-3g-devel", rpm:"ntfs-3g-devel~1.913~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ntfs-3g-debuginfo", rpm:"ntfs-3g-debuginfo~1.913~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ntfs-3g-devel", rpm:"ntfs-3g-devel~1.913~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ntfs-3g-debuginfo", rpm:"ntfs-3g-debuginfo~1.913~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ntfs-3g", rpm:"ntfs-3g~1.913~2.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}