###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for tcpdump FEDORA-2007-348
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861514);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-348");
  script_cve_id("CVE-2007-1218");
  script_name( "Fedora Update for tcpdump FEDORA-2007-348");
  desc = "

  Vulnerability Insight:
  Tcpdump is a command-line tool for monitoring network traffic.
  Tcpdump can capture and display the packet headers on a particular
  network interface or on all interfaces.  Tcpdump can display all of
  the packet headers, or just the ones that match particular criteria.
  
  Install tcpdump if you need a program to monitor network traffic


  Affected Software/OS:
  tcpdump on Fedora Core 5

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-March/msg00054.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of tcpdump");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC5")
{

  if(isrpmvuln(pkg:"tcpdump", rpm:"tcpdump~3.9.4~4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/libpcap", rpm:"x86_64/libpcap~0.9.4~4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/tcpdump", rpm:"x86_64/tcpdump~3.9.4~4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/arpwatch", rpm:"x86_64/arpwatch~2.1a13~15.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/tcpdump-debuginfo", rpm:"x86_64/debug/tcpdump-debuginfo~3.9.4~4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/tcpdump", rpm:"i386/tcpdump~3.9.4~4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/arpwatch", rpm:"i386/arpwatch~2.1a13~15.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/tcpdump-debuginfo", rpm:"i386/debug/tcpdump-debuginfo~3.9.4~4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/libpcap", rpm:"i386/libpcap~0.9.4~4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}