###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for dovecot FEDORA-2007-493
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861394);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-493");
  script_cve_id("CVE-2007-2231", "CVE-2006-5973");
  script_name( "Fedora Update for dovecot FEDORA-2007-493");
  desc = "

  Vulnerability Insight:
  Dovecot is an IMAP server for Linux/UNIX-like systems, written with security
  primarily in mind.  It also contains a small POP3 server.  It supports mail
  in either of maildir or mbox formats


  Affected Software/OS:
  dovecot on Fedora Core 5

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-May/msg00005.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of dovecot");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC5")
{

  if(isrpmvuln(pkg:"dovecot", rpm:"dovecot~1.0~0.beta8.4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/dovecot", rpm:"x86_64/dovecot~1.0~0.beta8.4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/dovecot-debuginfo", rpm:"x86_64/debug/dovecot-debuginfo~1.0~0.beta8.4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/dovecot", rpm:"i386/dovecot~1.0~0.beta8.4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/dovecot-debuginfo", rpm:"i386/debug/dovecot-debuginfo~1.0~0.beta8.4.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}