###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for seamonkey FEDORA-2007-552
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861490);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-552");
  script_cve_id("CVE-2007-2867", "CVE-2007-2868", "CVE-2007-1562", "CVE-2007-1362", "CVE-2007-2869", "CVE-2007-1558", "CVE-2007-2870", "CVE-2007-2871");
  script_name( "Fedora Update for seamonkey FEDORA-2007-552");
  desc = "

  Vulnerability Insight:
  SeaMonkey (former Mozilla) is an open-source web browser, designed for standards
  compliance, performance and portability.


  Affected Software/OS:
  seamonkey on Fedora Core 5

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-May/msg00066.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of seamonkey");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC5")
{

  if(isrpmvuln(pkg:"seamonkey", rpm:"seamonkey~1.0.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/seamonkey-dom-inspector", rpm:"x86_64/seamonkey-dom-inspector~1.0.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/seamonkey-devel", rpm:"x86_64/seamonkey-devel~1.0.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/seamonkey-js-debugger", rpm:"x86_64/seamonkey-js-debugger~1.0.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/seamonkey", rpm:"x86_64/seamonkey~1.0.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/seamonkey-chat", rpm:"x86_64/seamonkey-chat~1.0.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/seamonkey-mail", rpm:"x86_64/seamonkey-mail~1.0.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/seamonkey-debuginfo", rpm:"x86_64/debug/seamonkey-debuginfo~1.0.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/seamonkey-devel", rpm:"i386/seamonkey-devel~1.0.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/seamonkey-dom-inspector", rpm:"i386/seamonkey-dom-inspector~1.0.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/seamonkey-debuginfo", rpm:"i386/debug/seamonkey-debuginfo~1.0.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/seamonkey-js-debugger", rpm:"i386/seamonkey-js-debugger~1.0.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/seamonkey-mail", rpm:"i386/seamonkey-mail~1.0.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/seamonkey", rpm:"i386/seamonkey~1.0.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/seamonkey-chat", rpm:"i386/seamonkey-chat~1.0.9~1.fc5", rls:"FC5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}