###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for libgtop2 FEDORA-2007-657
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861221);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-657");
  script_cve_id("CVE-2007-0235");
  script_name( "Fedora Update for libgtop2 FEDORA-2007-657");
  desc = "

  Vulnerability Insight:
  libgtop is a library for portably obtaining information about processes,
  such as their PID, memory usage, etc


  Affected Software/OS:
  libgtop2 on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-August/msg00128.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of libgtop2");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"libgtop2", rpm:"libgtop2~2.14.9~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/libgtop2-devel", rpm:"x86_64/libgtop2-devel~2.14.9~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/libgtop2", rpm:"x86_64/libgtop2~2.14.9~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/libgtop2-debuginfo", rpm:"x86_64/debug/libgtop2-debuginfo~2.14.9~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/libgtop2", rpm:"i386/libgtop2~2.14.9~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/libgtop2-devel", rpm:"i386/libgtop2-devel~2.14.9~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/libgtop2-debuginfo", rpm:"i386/debug/libgtop2-debuginfo~2.14.9~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}